/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.tree;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SimpleTreeEvent;
import com.ibm.hwmca.fw.util.tree.SimpleTreeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SimpleTreeNode
implements Serializable,
Cloneable {
    protected Object userObject;
    protected SimpleTreeNode parent;
    protected ArrayList children;
    private transient ArrayList listeners;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    protected static ArrayList EMPTY_LIST = new ArrayList();
    private static final String TRACE_MASKT = "XFTREE T";
    private static final String TRACE_MASKF = "XFTREE F";
    private static final String TRACE_MASKD = "XFTREE D";
    private static final String BLANKS = "                                        ";

    public SimpleTreeNode() {
        this(null);
    }

    public SimpleTreeNode(Object userObject) {
        this.userObject = userObject;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public SimpleTreeNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public List getLeaves() {
        if (this.hasChildren()) {
            return this.getLeaves(new ArrayList());
        }
        return EMPTY_LIST;
    }

    private List getLeaves(List leaves) {
        if (this.isLeaf()) {
            leaves.add(this);
        } else {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                child.getLeaves(leaves);
            }
        }
        return leaves;
    }

    public int getLevel() {
        int level = 0;
        for (SimpleTreeNode nextParent = this.parent; nextParent != null; nextParent = nextParent.getParent()) {
            ++level;
        }
        return level;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean add(SimpleTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        child.parent = this;
        boolean result = this.children.add(child);
        if (result) {
            this.sendAddEvent(child);
        }
        return result;
    }

    public void addChildAt(int index, SimpleTreeNode child) throws IndexOutOfBoundsException {
        if (this.children == null) {
            this.add(child);
        } else {
            int size = this.children.size();
            if (index == size) {
                this.add(child);
            } else if (index < size) {
                child.parent = this;
                this.children.add(index, child);
                this.sendAddEvent(child);
            } else {
                String s = "SimpleTreeNode.addChildAt() error, index " + index + " is greater than the number of childen: " + size;
                Trace.trace(TRACE_MASKF, s);
                throw new IndexOutOfBoundsException(s);
            }
        }
    }

    public boolean add(List children) {
        boolean result = false;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (result) {
                this.add((SimpleTreeNode)children.get(i));
                continue;
            }
            result = this.add((SimpleTreeNode)children.get(i));
        }
        return result;
    }

    public boolean remove(SimpleTreeNode child) {
        boolean result;
        if (this.children == null) {
            result = false;
        } else {
            result = this.children.remove(child);
            if (result) {
                child.parent = null;
                this.sendRemoveEvent(child);
            }
        }
        return result;
    }

    public boolean removeAll() {
        boolean result;
        if (this.children == null || this.children.isEmpty()) {
            result = false;
        } else {
            result = true;
            List listeners = this.getListeners();
            if (listeners == null || listeners.isEmpty()) {
                this.children.clear();
            } else {
                int size = this.children.size();
                for (int i = 0; i < size; ++i) {
                    SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                    this.children.remove(child);
                    this.sendRemoveEvent(child);
                }
            }
        }
        return result;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public SimpleTreeNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (this.children == null) {
            String s = "Warning, SimpleTreeNode.getChildAt() was called but no child nodes exist.";
            Trace.trace(TRACE_MASKF, s);
            throw new IndexOutOfBoundsException(s);
        }
        return (SimpleTreeNode)this.children.get(index);
    }

    public void setChildAt(int index, SimpleTreeNode child) throws IndexOutOfBoundsException {
        if (this.children == null) {
            String s = "Warning, SimpleTreeNode.getChildAt() was called but no child nodes exist.";
            Trace.trace(TRACE_MASKF, s);
            throw new IndexOutOfBoundsException(s);
        }
        this.children.set(index, child);
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return !this.children.isEmpty();
    }

    public List getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return EMPTY_LIST;
        }
        return (List)this.children.clone();
    }

    public List getNodesForUserObject(Object userObject) {
        ArrayList<SimpleTreeNode> foundNodes = new ArrayList<SimpleTreeNode>();
        if (this.userObject != null && this.userObject.equals(userObject)) {
            foundNodes.add(this);
        }
        return this.getDecendentNodesForUserObject(userObject, foundNodes);
    }

    public List getChildNodesForUserObject(Object userObject) {
        ArrayList<SimpleTreeNode> foundNodes = new ArrayList<SimpleTreeNode>();
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                if (!child.userObject.equals(userObject)) continue;
                foundNodes.add(child);
            }
        }
        return foundNodes;
    }

    public boolean containsChildNodesForUserObject(Object userObject) {
        boolean result = false;
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size && !result; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                if (!child.userObject.equals(userObject)) continue;
                result = true;
            }
        }
        return result;
    }

    private List getDecendentNodesForUserObject(Object userObject, List foundNodes) {
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                if (child.userObject.equals(userObject)) {
                    foundNodes.add(child);
                }
                child.getDecendentNodesForUserObject(userObject, foundNodes);
            }
        }
        return foundNodes;
    }

    public SimpleTreeNode getFirstNodeForUserObject(Object userObject) {
        if (this.userObject != null && this.userObject.equals(userObject)) {
            return this;
        }
        SimpleTreeNode result = null;
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size && result == null; ++i) {
                result = ((SimpleTreeNode)this.children.get(i)).getFirstNodeForUserObject(userObject);
            }
        }
        return result;
    }

    public boolean removeNodesForUserObject(Object userObject) {
        boolean result = false;
        if (this.hasChildren()) {
            List children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)children.get(i);
                if (child.getUserObject().equals(userObject)) {
                    if (result) {
                        this.remove(child);
                        continue;
                    }
                    result = this.remove(child);
                    continue;
                }
                child.removeNodesForUserObject(userObject);
            }
        }
        return result;
    }

    public Set getUniqueUserObjects() {
        return this.getUniqueUserObjects(new HashSet());
    }

    public Set getUniqueUserObjects(HashSet uniqueIds) {
        if (this.userObject != null && !uniqueIds.contains(this.userObject)) {
            uniqueIds.add(this.userObject);
        }
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            SimpleTreeNode nextNode = (SimpleTreeNode)iterator.next();
            nextNode.getUniqueUserObjects(uniqueIds);
        }
        return uniqueIds;
    }

    public SimpleTreeNode getParent() {
        return this.parent;
    }

    public void addTreeListener(SimpleTreeListener listener) {
        this.getListeners().add(listener);
    }

    private List getListeners() {
        SimpleTreeNode root = this.getRoot();
        if (root.listeners == null) {
            root.listeners = new ArrayList();
        }
        return root.listeners;
    }

    public void removeTreeListener(SimpleTreeListener listener) {
        this.getListeners().remove(listener);
    }

    public void removeAllTreeListeners() {
        this.getListeners().clear();
    }

    private void sendRemoveEvent(SimpleTreeNode child) {
        SimpleTreeEvent evt = new SimpleTreeEvent(this, child);
        this.sendEvent(2, evt);
    }

    private void sendAddEvent(SimpleTreeNode child) {
        SimpleTreeEvent evt = new SimpleTreeEvent(this, child);
        this.sendEvent(1, evt);
    }

    private synchronized void sendEvent(int eventType, SimpleTreeEvent evt) {
        List listeners = this.getListeners();
        int size = listeners.size();
        block4: for (int i = 0; i < size; ++i) {
            SimpleTreeListener listener = (SimpleTreeListener)listeners.get(i);
            switch (eventType) {
                case 1: {
                    listener.treeNodeAdded(evt);
                    continue block4;
                }
                case 2: {
                    listener.treeNodeRemoved(evt);
                }
            }
        }
    }

    public Object clone() {
        SimpleTreeNode clone = null;
        try {
            clone = (SimpleTreeNode)super.clone();
            clone.listeners = null;
            clone.parent = null;
            clone.userObject = this.userObject;
            if (this.hasChildren()) {
                clone.children = new ArrayList();
                int size = this.children.size();
                for (int i = 0; i < size; ++i) {
                    SimpleTreeNode child = (SimpleTreeNode)this.children.get(i);
                    SimpleTreeNode clonedChild = (SimpleTreeNode)child.clone();
                    clone.children.add(clonedChild);
                    clonedChild.parent = clone;
                }
            } else {
                clone.children = null;
            }
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, this.toString());
        }
        return clone;
    }

    public void dump() {
        Trace.trace(TRACE_MASKF, this.toString());
        this.dumpChildren(this, 1);
    }

    private void dumpChildren(SimpleTreeNode parent, int level) {
        if (parent.children != null && parent.hasChildren()) {
            String blanks = level < BLANKS.length() / 2 ? BLANKS.substring(0, level * 2) : BLANKS;
            int size = parent.children.size();
            for (int i = 0; i < size; ++i) {
                SimpleTreeNode child = (SimpleTreeNode)parent.children.get(i);
                Trace.trace(TRACE_MASKF, blanks + child.toString());
                this.dumpChildren(child, level + 1);
            }
        }
    }

    public String toString() {
        return super.toString() + ",root=" + this.isRoot() + ",level=" + this.getLevel() + ",childCount=" + this.getChildCount() + ",userObject=[" + this.getUserObject() + "]";
    }
}

